/**
 * SendinBlue API
 * SendinBlue provide a RESTFul API that can be used with any languages. With this API, you will be able to :   - Manage your campaigns and get the statistics   - Manage your contacts   - Send transactional Emails and SMS   - and much more...  You can download our wrappers at https://github.com/orgs/sendinblue  **Possible responses**   | Code | Message |   | :-------------: | ------------- |   | 200  | OK. Successful Request  |   | 201  | OK. Successful Creation |   | 202  | OK. Request accepted |   | 204  | OK. Successful Update/Deletion  |   | 400  | Error. Bad Request  |   | 401  | Error. Authentication Needed  |   | 402  | Error. Not enough credit, plan upgrade needed  |   | 403  | Error. Permission denied  |   | 404  | Error. Object does not exist |   | 405  | Error. Method not allowed  |   | 406  | Error. Not Acceptable  | 
 *
 * OpenAPI spec version: 3.0.0
 * Contact: contact@sendinblue.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 *
 * Swagger Codegen version: 2.3.1
 *
 * Do not edit the class manually.
 *
 */

(function(root, factory) {
  if (typeof define === 'function' && define.amd) {
    // AMD. Register as an anonymous module.
    define(['ApiClient'], factory);
  } else if (typeof module === 'object' && module.exports) {
    // CommonJS-like environments that support module.exports, like Node.
    module.exports = factory(require('../ApiClient'));
  } else {
    // Browser globals (root is window)
    if (!root.SibApiV3Sdk) {
      root.SibApiV3Sdk = {};
    }
    root.SibApiV3Sdk.GetExtendedClientAddress = factory(root.SibApiV3Sdk.ApiClient);
  }
}(this, function(ApiClient) {
  'use strict';




  /**
   * The GetExtendedClientAddress model module.
   * @module model/GetExtendedClientAddress
   * @version 8.2.0
   */

  /**
   * Constructs a new <code>GetExtendedClientAddress</code>.
   * Address informations
   * @alias module:model/GetExtendedClientAddress
   * @class
   * @param street {String} Street information
   * @param city {String} City information
   * @param zipCode {String} Zip Code information
   * @param country {String} Country information
   */
  var exports = function(street, city, zipCode, country) {
    var _this = this;

    _this['street'] = street;
    _this['city'] = city;
    _this['zipCode'] = zipCode;
    _this['country'] = country;
  };

  /**
   * Constructs a <code>GetExtendedClientAddress</code> from a plain JavaScript object, optionally creating a new instance.
   * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
   * @param {Object} data The plain JavaScript object bearing properties of interest.
   * @param {module:model/GetExtendedClientAddress} obj Optional instance to populate.
   * @return {module:model/GetExtendedClientAddress} The populated <code>GetExtendedClientAddress</code> instance.
   */
  exports.constructFromObject = function(data, obj) {
    if (data) {
      obj = obj || new exports();

      if (data.hasOwnProperty('street')) {
        obj['street'] = ApiClient.convertToType(data['street'], 'String');
      }
      if (data.hasOwnProperty('city')) {
        obj['city'] = ApiClient.convertToType(data['city'], 'String');
      }
      if (data.hasOwnProperty('zipCode')) {
        obj['zipCode'] = ApiClient.convertToType(data['zipCode'], 'String');
      }
      if (data.hasOwnProperty('country')) {
        obj['country'] = ApiClient.convertToType(data['country'], 'String');
      }
    }
    return obj;
  }

  /**
   * Street information
   * @member {String} street
   */
  exports.prototype['street'] = undefined;
  /**
   * City information
   * @member {String} city
   */
  exports.prototype['city'] = undefined;
  /**
   * Zip Code information
   * @member {String} zipCode
   */
  exports.prototype['zipCode'] = undefined;
  /**
   * Country information
   * @member {String} country
   */
  exports.prototype['country'] = undefined;



  return exports;
}));


