/**
 * SendinBlue API
 * SendinBlue provide a RESTFul API that can be used with any languages. With this API, you will be able to :   - Manage your campaigns and get the statistics   - Manage your contacts   - Send transactional Emails and SMS   - and much more...  You can download our wrappers at https://github.com/orgs/sendinblue  **Possible responses**   | Code | Message |   | :-------------: | ------------- |   | 200  | OK. Successful Request  |   | 201  | OK. Successful Creation |   | 202  | OK. Request accepted |   | 204  | OK. Successful Update/Deletion  |   | 400  | Error. Bad Request  |   | 401  | Error. Authentication Needed  |   | 402  | Error. Not enough credit, plan upgrade needed  |   | 403  | Error. Permission denied  |   | 404  | Error. Object does not exist |   | 405  | Error. Method not allowed  |   | 406  | Error. Not Acceptable  | 
 *
 * OpenAPI spec version: 3.0.0
 * Contact: contact@sendinblue.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 *
 * Swagger Codegen version: 2.3.1
 *
 * Do not edit the class manually.
 *
 */

(function(root, factory) {
  if (typeof define === 'function' && define.amd) {
    // AMD. Register as an anonymous module.
    define(['ApiClient'], factory);
  } else if (typeof module === 'object' && module.exports) {
    // CommonJS-like environments that support module.exports, like Node.
    module.exports = factory(require('../ApiClient'));
  } else {
    // Browser globals (root is window)
    if (!root.SibApiV3Sdk) {
      root.SibApiV3Sdk = {};
    }
    root.SibApiV3Sdk.SendSms = factory(root.SibApiV3Sdk.ApiClient);
  }
}(this, function(ApiClient) {
  'use strict';




  /**
   * The SendSms model module.
   * @module model/SendSms
   * @version 8.2.0
   */

  /**
   * Constructs a new <code>SendSms</code>.
   * @alias module:model/SendSms
   * @class
   * @param reference {String} 
   * @param messageId {Number} 
   */
  var exports = function(reference, messageId) {
    var _this = this;

    _this['reference'] = reference;
    _this['messageId'] = messageId;



  };

  /**
   * Constructs a <code>SendSms</code> from a plain JavaScript object, optionally creating a new instance.
   * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
   * @param {Object} data The plain JavaScript object bearing properties of interest.
   * @param {module:model/SendSms} obj Optional instance to populate.
   * @return {module:model/SendSms} The populated <code>SendSms</code> instance.
   */
  exports.constructFromObject = function(data, obj) {
    if (data) {
      obj = obj || new exports();

      if (data.hasOwnProperty('reference')) {
        obj['reference'] = ApiClient.convertToType(data['reference'], 'String');
      }
      if (data.hasOwnProperty('messageId')) {
        obj['messageId'] = ApiClient.convertToType(data['messageId'], 'Number');
      }
      if (data.hasOwnProperty('smsCount')) {
        obj['smsCount'] = ApiClient.convertToType(data['smsCount'], 'Number');
      }
      if (data.hasOwnProperty('usedCredits')) {
        obj['usedCredits'] = ApiClient.convertToType(data['usedCredits'], 'Number');
      }
      if (data.hasOwnProperty('remainingCredits')) {
        obj['remainingCredits'] = ApiClient.convertToType(data['remainingCredits'], 'Number');
      }
    }
    return obj;
  }

  /**
   * @member {String} reference
   */
  exports.prototype['reference'] = undefined;
  /**
   * @member {Number} messageId
   */
  exports.prototype['messageId'] = undefined;
  /**
   * Count of SMS's to send multiple text messages
   * @member {Number} smsCount
   */
  exports.prototype['smsCount'] = undefined;
  /**
   * SMS credits used per text message
   * @member {Number} usedCredits
   */
  exports.prototype['usedCredits'] = undefined;
  /**
   * Remaining SMS credits of the user
   * @member {Number} remainingCredits
   */
  exports.prototype['remainingCredits'] = undefined;



  return exports;
}));


